// DtTwinSlider.cpp : implementation file
//

#include "stdafx.h"
#include "misc_stuff.h"
#include "DtTwinSlider.h"
#include "DtMfcStuff.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------------------
DtTwinSlider::DtTwinSlider()
{
	setNumSliders(2); /*DtSliderBase*/
}

//----------------------------------------------------------------------------------------------------
DtTwinSlider::~DtTwinSlider()
{
}


//----------------------------------------------------------------------------------------------------
void DtTwinSlider::drawRect(void)
{
	// draw background rectangle
	CRect r;
	r.top = 0;
	r.bottom = client_rect.Height();
	if(s[1]->screen_pos >= s[0]->screen_pos) {
		// include region
		r.left = s[0]->screen_pos;
		r.right = s[1]->screen_pos;
		mem_dc->FillRect(&r, &CBrush(0x000050UL));
	}
	else {
		// exclude region
		r.left = 0;
		r.right = s[1]->screen_pos;
		mem_dc->FillRect(&r, &CBrush(0x000050UL));
		r.left = s[0]->screen_pos;
		r.right = client_rect.Width();
		mem_dc->FillRect(&r, &CBrush(0x000050UL));
	}
}

//----------------------------------------------------------------------------------------------------
void DtTwinSlider::drawKnobs(void)
// draw knobs and lines
{
	int i;
	CRect r[2];
	r[0].top = 0;
	r[0].bottom = 10;
	r[1].top = client_rect.Height()-10;
	r[1].bottom = client_rect.Height();

	for(i = 0; i < 2; i++) {
		COLORREF col = knobStateColour(i);

		r[i].left = s[i]->screen_pos-5;
		r[i].right = s[i]->screen_pos+5+1;
		mem_dc->FillRect(&r[i], &CBrush(col));

		CPen a_pen(PS_SOLID,1,col);
		mem_dc->SelectObject(&a_pen);
		mem_dc->MoveTo(CPoint(s[i]->screen_pos, 0));
		mem_dc->LineTo(CPoint(s[i]->screen_pos, client_rect.Height()));
	}
}

//----------------------------------------------------------------------------------------------------
void DtTwinSlider::drawControl(void)
// override DtCtrl::drawControl()
{
	int i;

	// get the size of edits
	CSize sz[2];
	DtSliderBase::prepareDrawText(sz);

	// determine positions for sliders
	CPoint p[2];
	p[0].y = 0;
	p[1].y = client_rect.bottom-sz[1].cy;
	for(i = 0; i < 2; i++) {
		if(!s[i]->isActive() || !edit_lock)
			s[i]->draw_text_left = s[i]->value > 0.5f;
		if(s[i]->draw_text_left) p[i].x = 2;
		else p[i].x = client_rect.right-sz[i].cx-2;
	}

	drawRect();
	drawCursor(p); /*declared in DtSliderBase*/
	drawKnobs();
	drawText(p); /*declared in DtSliderBase*/
}

//----------------------------------------------------------------------------------------------------
void DtTwinSlider::selectSlider(void)
// override DtSliderBase::selectSlider()
//
// select which slider is active based on "y" position of mouse
{
	DtSliderBase::selectSlider(curr_point.y < client_rect.Height()/2 ? 0 : 1);
}

